/*  B A S T A R D    A P I  :  */
/*  */

#include <bdb.h>  /* main DB structure definitions */

/* Public Parts */
   /* Macro Types */
#define BC_CODE   0x01
#define BC_FILE   0x02
/*  script_file_exec: Run a script contained in a file 
 *    Return Value:   Exit status of script
 *     Arguments:      char *name -- name of file to compile and execute */
int script_file_exec( char *name );
/*  script_text_exec: Compile and run the provided code
 *    Return Value:   Exit status of script
 *     Arguments:      char *script -- code to compile and execute */
int script_text_exec( char *script );
/*  script_compiled_exec: Run a precompiled script
 *    Return Value:     Exit status of script
 *     Arguments:        char *name -- name of file to load and run */
int script_compiled_exec(char *name);
/*  script_compile: Compile a script file
 *    Return Value:   1 if success, 0 if failure
 *     Arguments:      char *name -- name of file to compile */
int script_compile(char *name);
/*  macro_new: 
 *    Return Value:   
 *     Arguments:       */
int macro_new( char *name, char *macro );
/*  macro_del: 
 *    Return Value:   
 *     Arguments:       */
int macro_del( char *name );
/*  macro_exec: 
 *    Return Value:   
 *     Arguments:       */
int macro_exec( char *name );
/*  macro_record: 
 *    Return Value:   
 *     Arguments:       */
int macro_record( char *name );
/* Private Parts ;)  */

#ifndef INCLUDED_FROM_BASTARD_H

#endif
