/*  B A S T A R D    A P I  :  */
/*  */

#include <limits.h>
#include <bdb.h>  /* main DB structure definitions */
#include <extensions/asm.h>

/* Public Parts */
/* bastard environment :  flags */
/*      Current state of target */
#define DB_LOADED       0x00000001        /* .bdb loaded */
#define TGT_MAPPED      0x00000002        /* target bin image mmap'ed */
#define DB_MOD          0x00000004        /* .bdb has been modified */
#define TGT MOD         0x00000008        /* target bin image modified */
/*      Current state of disassembly */
#define PASS_1          0x00000010        /* main disassembly pass */
#define PASS_2          0x00000020        /* subsequent passes */
#define CODE_INT        0x00000040        /* intermediate code rep is done */
#define CODE_FIN        0x00000080        /* final code rep is done */
/*      Safety stuff */
#define DISABLE_EXEC    0x00010000  /* do not allow shell escapes */
#define IN_EIC          0x00020000  /* do not allow shell escapes */
#define QUIT_NOW        0x00080000  /* Easier this way */
/*     *Bastard Prefs: OPTIONS *        */
/*      User convenience */
#define PAGINATE        0x00000100
#define COLOR_TTY       0x00000200
/*      User inconvenience ;) */
#define NO_VISUALS	0x00000400  /* disable ascii graphics */
#define QUIET           0x00001000  /* print std msgs to STDOUT */
#define ANNOY_USER      0x00002000  /* bug user with save prompts, etc */
#define DONT_SAVE       0x00004000  /* do not save the DB *ever* */
#define DEBUG_TIME      0x00008000  /* horrendous debug output */
/*      Auto-Disasm controls */
#define DISASM_REDO     0x00100000  /* redo existing code [default: skip it] */

/* bastard environment :  structs */
struct DISASM_ENV {
      char   home[256]; /* bastard dir info */
	char   base[PATH_MAX];		/* parent dir: infer bin, lib from this */
	char   share[PATH_MAX];		/* location of extensions, scripts, etc */
	char   inc[PATH_MAX];		/* include files, e.g. for EiC */
      char   p1[16];    /* main prompt */
      char   p2[16];    /* multiline prompt */
      char   p3[16];    /* 'other' prompt */
      char   p4[16];    /* help system prompt */
      /* .asm file format and lpr format will be in assembler struct */
      char   dbpath[256];
      int    output;   /* default output type */
      int    flags;
      int    endian;    /* big or little endian? 1= little */
};

struct DISASM_PREFS {
      char pager[PATH_MAX]; /* default pager to use */
      char editor[PATH_MAX]; /* default editor to use */
      char debugger[PATH_MAX]; /* default editor to use */
      int options;
      int override;
      int num_hist;           /* number of cmd history to remember */
};



/* TODO : add some semblence or order to these: */
char * env_get_base();
char * env_get_inc();
char * env_get_share();
/* this sets base, inc, and share */
int env_set_base(char *base);
/* These are the best way to set things : */
int env_set_setting(char *group, char *name, char *val);
void * env_get_setting(char *group, char *name);
int env_set_option(char *option);
int env_get_option(char *option);
/* Other 'Set' cmds may be removed in the future */
int env_set_pager(char *name);
int env_set_editor(char *name);
int env_set_debugger(char *name); 
    /* shouldn't these 4 be in api_target.h? */
char * env_get_pager();
char * env_get_editor();
char * env_get_debugger(); 
struct DISASM_ENV   * env_get_env();
struct DISASM_PREFS * env_get_prefs();
struct DISASM_TGT   * env_get_target();
   /* shouldn't these 3 be in extension.h ? */
struct DISASM_ENG   * env_get_engine();
struct DISASM_ASM   * env_get_asm();
struct DISASM_LANG  * env_get_lang();
int env_clear();
int env_clear_target();
int env_defaults();
int env_target_defaults();
int env_pref_defaults();
/*  env_get_flag: Test whether environment flag is true. Flags:
 *                     DB_LOADED TGT_MAPPED DB_MOD TGT MOD PASS_1 PASS_2
 *                     CODE_INT CODE_FIN PAGINATE COLOR_TTY QUIET ANNOY_USER
 *                     DISABLE_EXEC DEBUG_LIB
 *    Return Value:   1 (set) or 0 (not set)
 *     Arguments:      int flag -- one of the above flags  */
int env_get_flag( int flag );
/*  env_set_flag: Set an environment flag 
 *    Return Value:   Returns 0 always
 *     Arguments:      int flag -- flag to set */
int env_set_flag( int flag );
/*  env_clear_flag: Un-set an environment flag 
 *    Return Value:   Returns 0 always
 *     Arguments:      int flag -- flag to clear */
int env_clear_flag( int flag );
int env_get_opt_flag( int flag );
int env_set_opt_flag( int flag );
int env_clear_opt_flag( int flag );
/*  env_tty_asm: Set asmsprintf format string for CODE on a tty
 *     Arguments:   char *fmt -- new default format string */
void env_tty_asm( char *fmt );
/*  env_tty_data: asmsprintf format string for DATA on a tty 
 *     Arguments:   char *fmt -- new default format string */
void env_tty_data( char *fmt );
/*  env_file_asm: asmsprintf format string for CODE to a file
 *     Arguments:   char *fmt -- new default format string */
void env_file_asm( char *fmt );
/*  env_file_data: asmsprintf format string for DATA to a file
 *     Arguments:   char *fmt -- new default format string */
void env_file_data( char *fmt );
/*  env_lpr_asm: asmsprintf format string for CODE on a printer
 *     Arguments:   char *fmt -- new default format string */
void env_lpr_asm( char *fmt );
/* env_lpr_data : asmsprintf format string for DATA on a printer
 *     Arguments:   char *fmt -- new default format string */
void env_lpr_data( char *fmt );

/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif
