/*  B A S T A R D    A P I  :  */
/*  */

#include <bdb.h>  /* main DB structure definitions */

/* Public Parts */
#define BIG_ENDIAN_ORD       0
#define LITTLE_ENDIAN_ORD    1
/*  disasm_create_header : Create ASCII representation of the program header
 *    Return Value:   1 id success , 0 if failure
 *     Arguments:      char *header = ASCII representation of header    */
int target_set_header( char *header); 
char * target_header( );
int disasm_target(char *disasm, void *param);
int disasm_address(unsigned long pa, struct code *c, unsigned long rva);
/*  disasm_section : Perform a linear disassembly of a section. This does
 *                       no flow-of execution; rather it calls DisassembleRange
 *                       for the starting rva & size of the section
 *    Return Value:   1 if success, 0 if failure
 *     Arguments:      char *name -- name of section to disassemble */
int disasm_section( char *name );
/*  disasm_range :   Perform a linear disassembly on a range of addresses;
 *                       this blindly disassembles instruction after instruction
 *                       with no branch following/etc, until the end of the
 *                       range is reached.
 *    Return Value:    1 if success, 0 if failure
 *     Arguments:       long rva  -- address to start disassembly at
 *                     int  size -- size of range to disassemble [in bytes] */
int disasm_range( unsigned long rva, int size );
/*  disasm_forward : Perform a flow-of-execution disassembly starting at
 *                       the given address. The disassembly attempts to 
 *                       follow branches and will not overwrite existing CODE
 *                       objects [they will be skipped -- as with the other
 *                       disassembly routines. this behavior is determined in
 *                       DisAddr(), the backend to all of these api routines].
 *    Return Value:   
 *     Arguments:       */
int disasm_forward( unsigned long rva );

unsigned long disasm_find_pat_in_range(unsigned long rva, int size, int type);
unsigned long disasm_find_func_in_range(unsigned long rva, int size);
unsigned long disasm_find_func_end(unsigned long rva);
int disasm_byte_order();
int disasm_addr_size();
int disasm_byte_size();
int disasm_word_size();
int disasm_dword_size();
int disasm_get_sp();
int disasm_get_ip();


/* Private Parts ;)  */
#ifndef INCLUDED_FROM_BASTARD_H

#endif
